# Inflector Gadget

Inflection mapping gadget for complex quadratic polynomials.

<https://mathr.co.uk/web/inflector-gadget.html>

## Controls

Press `H` to show help screen.

## Download

See <https://mathr.co.uk/web/inflector-gadget.html#Download> for:

- binaries for Web (tested in Firefox, served by Python)
- binaries for Microsoft Windows (tested in Wine)
- source code for all platforms (tested on Debian Bookworm)
- GPG signatures for the above

## Run

### Desktop

Run the program in the usual way:

- launch `./inflector-gadget` for Linux (requires build)
- launch `inflector-gadget.$(arch).exe` for Windows

### Web

The legacy versions 1 and 2 don't need any special server.

The current version 4, and previous version 3,
need to be built with Emscripten,
and served with custom HTTP headers, for example:

    cd inflector-gadget/web
    ../src/serve.py
    # visit http://localhost:8080 in web browser

## Source

Stable release bundle:

    tar xaf inflector-gadget-$VERSION.tar.bz2
    cd inflector-gadget-$VERSION

Development in progress:

    git clone https://code.mathr.co.uk/inflector-gadget.git
    cd inflector-gadget

## Build

Developed and tested on Debian Bookworm.

### System Dependencies

    sudo apt install \
        build-essential \
        git \
        libsdl2-dev \
        libpng-dev \
        libtoml11-dev \
        libmpc-dev

You can install dependencies for Windows (MINGW and LLVM-MINGW) and Web
(Emscripten) with <https://mathr.co.uk/web/build-scripts.html>.
You need to run something like:

    ./BUILD.sh download            "emsdk opengl glm gmp mpfr mpc toml11 zlib png sdl2"
    ./BUILD.sh x86_64-w64-mingw32  "emsdk opengl glm gmp mpfr mpc toml11 zlib png sdl2"
    ./BUILD.sh i686-w64-mingw32    "emsdk opengl glm gmp mpfr mpc toml11 zlib png sdl2"
    ./BUILD.sh aarch64-w64-mingw32 "emsdk opengl glm gmp mpfr mpc toml11 zlib png sdl2"
    ./BUILD.sh armv7-w64-mingw32   "emsdk opengl glm gmp mpfr mpc toml11 zlib png sdl2"
    ./BUILD.sh emscripten          "emsdk opengl glm gmp mpfr mpc toml11"

Emscripten ports are used for zlib, png and sdl2.

### Source Dependencies

    cd inflector-gadget-$VERSION
    git clone https://github.com/ocornut/imgui.git
    git clone https://github.com/AirGuanZ/imgui-filebrowser.git
    git clone https://github.com/Armchair-Software/emscripten-browser-clipboard.git
    git clone https://github.com/Armchair-Software/emscripten-browser-file.git
    cd emscripten-browser-file
    patch -p 1 < ../src/emscripten_browser_file.patch
    cd ..

### Build With Make

    cd inflector-gadget-$VERSION/src
    make
    make SYSTEM=web
    make SYSTEM=windows
    make SYSTEM=windows ARCH=x86_64
    make SYSTEM=windows ARCH=i686
    make SYSTEM=windows ARCH=aarch64
    make SYSTEM=windows ARCH=armv7

## Security

Settings files may set extreme resolutions or iteration counts.
This might (in a bad case) crash your desktop session losing data
in any unsaved documents.

Be careful when opening settings from untrusted sources.

To mitigate the problems this might cause when starting the
desktop version from the command line, you can append another
settings file to reconfigure afterwards.

Example contents of `failsafe.ig.toml`:

    width = 640
    height = 360
    fullscreen = false
    oversample = 1
    undersample = 1
    samples = 1
    iterations = 256
    algorithm = 0
    period = 1
    extrapolate = 0

Example invocation:

    ./inflector-gadget untrusted.ig.toml failsafe.ig.toml

## Legal

Inflector Gadget -- Inflection mapping gadget for complex quadratic polynomials.

Copyright (C) 2017-2025 Claude Heiland-Allen

Inflector Gadget is free software: you can redistribute it and/or modify
it under the terms of the GNU Affero General Public License as
published by the Free Software Foundation, version 3 of the
License.

Inflector Gadget is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with Inflector Gadget.  If not, see <https://www.gnu.org/licenses/>.
